/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.MapProcessor;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.MySmallButton;
import xaero.map.settings.ModOptions;

public class ExportScreen
extends GuiSettings {
    private static final Component EXPORTING_MESSAGE = Component.translatable((String)"gui.xaero_export_screen_exporting");
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(Screen backScreen, Screen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super((Component)Component.translatable((String)"gui.xaero_export_screen"), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.FULL_EXPORT), new ConfigSettingEntry(ModOptions.MULTIPLE_IMAGES_EXPORT), new ConfigSettingEntry(ModOptions.NIGHT_EXPORT), new ConfigSettingEntry(ModOptions.EXPORT_HIGHLIGHTS), new ConfigSettingEntry(ModOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.shouldAddBackButton = false;
    }

    @Override
    public void init() {
        if (this.stage > 0) {
            return;
        }
        super.init();
        this.addRenderableWidget((GuiEventListener)new MySmallButton(this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            this.stage = 1;
            this.init(this.minecraft, this.width, this.height);
        }));
        this.addRenderableWidget((GuiEventListener)new MySmallButton(this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderEscapeScreen(guiGraphics, 0, 0, f);
        super.renderBackground(guiGraphics, i, j, f);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        super.render(guiGraphics, par1, par2, par3);
        if (this.result != null) {
            guiGraphics.drawCenteredString(this.minecraft.font, this.result.getMessage(), this.width / 2, 20, -1);
        }
        if (this.stage > 0) {
            guiGraphics.drawCenteredString(this.minecraft.font, EXPORTING_MESSAGE, this.width / 2, this.height / 6 + 68, -1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (GuiEventListener c : this.children()) {
                if (!(c instanceof Button)) continue;
                ((Button)c).active = false;
            }
            return;
        }
        this.stage = 0;
        this.init(this.minecraft, this.width, this.height);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

